// infix.java
// przeksztaca wyraenia wrostkowe na przyrostkowe
// uruchomienie programu: C>java InfixApp
import java.io.*;            // operacje wejcia-wyjcia
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;
   private char[] stackArray;
   private int top;
//--------------------------------------------------------------
   public StackX(int s)       // konstruktor
      {
      maxSize = s;
      stackArray = new char[maxSize];
      top = -1;
      }
//--------------------------------------------------------------
   public void push(char j)  // odkada znak na stosie
      { stackArray[++top] = j; }
//--------------------------------------------------------------
   public char pop()         // zdejmuje znak ze stosu
      { return stackArray[top--]; }
//--------------------------------------------------------------
   public char peek()        // podglda znak na szczycie stosu
      { return stackArray[top]; }
//--------------------------------------------------------------
   public boolean isEmpty()  // zwraca true, jeeli stos pusty
      { return (top == -1); }
//-------------------------------------------------------------
   public int size()         // zwraca ilo elementw na stosie
      { return top+1; }
//--------------------------------------------------------------
   public char peekN(int n)  // zwraca element o indeksie n
      { return stackArray[n]; }
//--------------------------------------------------------------
   public void displayStack(String s)
      {
      System.out.print(s);
      System.out.print("stos (dno-->szczyt): ");
      for(int j=0; j<size(); j++)
         {
         System.out.print( peekN(j) );
         System.out.print(' ');
         }
      System.out.println("");
      }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class InToPost                  // przeksztaca z notacji wrostkowej na przyrostkow
   {
   private StackX theStack;
   private String input;
   private String output = "";
//--------------------------------------------------------------
   public InToPost(String in)   // konstruktor
      {
      input = in;
      int stackSize = input.length();
      theStack = new StackX(stackSize);
      }
//--------------------------------------------------------------
   public String doTrans()      // wykonuje przeksztacenie
      {
      for(int j=0; j<input.length(); j++)      // dla kadego znaku...
         {
         char ch = input.charAt(j);            // ...pobieramy go z wejcia
         theStack.displayStack("for "+ch+" "); // *diagnostyka*
         switch(ch)
            {
            case '+':               // + albo -
            case '-':
               gotOper(ch, 1);      // zdejmujemy operatory o priorytecie wikszym ni 1
               break;              
            case '*':               // * albo /
            case '/':
               gotOper(ch, 2);      // zdejmujemy operatory o priorytecie wikszym ni 2
               break;
            case '(':               // nawias otwierajcy...
               theStack.push(ch);   // ...odkadamy na stosie
               break;
            case ')':               // nawias zamykajcy...
               gotParen(ch);        // zdejmujemy operatory
               break;
            default:                // argument...
               output = output + ch; // ...kopiujemy na wyjcie
               break;
            }  // koniec switch
         }  // koniec for
      while( !theStack.isEmpty() )     // zdejmujemy pozostae na stosie operatory...
         {
         theStack.displayStack("while ");  // *diagnostyka*
         output = output + theStack.pop(); // ...i kopiujemy na wyjcie
         }
      theStack.displayStack("Koniec ");     // *diagnostyka*
      return output;                   // zwracamy wyraenie przyrostkowe
      }  // koniec doTrans()
//--------------------------------------------------------------
   public  void gotOper(char opThis, int prec1)
      {                                // pobrano operator z wejcia
      while( !theStack.isEmpty() )
         {
         char opTop = theStack.pop();
         if( opTop == '(' )            // jeeli to '('
            {
            theStack.push(opTop);      // odkadamy '('
            break;
            }
         else                          // to operator
            {
            int prec2;                 // priorytet zdjtego operatora

            if(opTop=='+' || opTop=='-')  // okrelamy priorytet zdjtego operatora
               prec2 = 1;
            else
               prec2 = 2;
            if(prec2 < prec1)          // jeeli priorytet zdjtego mniejszy...
               {                       // ...ni wczytanego z wejcia
               theStack.push(opTop);   // odkadamy na stosie zdjty operator 
               break;
               }
            else                       // priorytet zdjtego operatora...
               output = output + opTop;  // ...nie mniejszy ni wczytanego
            }  // koniec else (to operator)
         }  // koniec while
      theStack.push(opThis);           // odkadamy nowy operator na stosie
      }  // koniec gotOper()
//--------------------------------------------------------------
   public  void gotParen(char ch)
      {                             // wczytano nawias zamykajcy
      while( !theStack.isEmpty() )
         {
         char chx = theStack.pop();
         if( chx == '(' )           // jeeli zdjto '('...
            break;                  // ...koniec ptli
         else                       // jeeli to operator...
            output = output + chx;  // ...kopiujemy go na wyjcie
         }  // koniec while
      }  // koniec gotParen()
//--------------------------------------------------------------
   }  // end class InToPost
////////////////////////////////////////////////////////////////
class InfixApp
   {
   public static void main(String[] args) throws IOException
      {
      String input, output;
      while(true)
         {
         System.out.print("Wprowad wyraenie wrostkowe: ");
         System.out.flush();
         input = getString();         // wczytujemy napis z klawiatury
         if( input.equals("") )       // koniec jeeli sam [Enter]
            break;
                                      // tworzymy obiekt tumaczcy
         InToPost theTrans = new InToPost(input);
         output = theTrans.doTrans(); // wykonujemy tumaczenie
         System.out.println("Posta przyrostkowa: " + output + '\n');
         }  // koniec while
      }  // koniec main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   }  // koniec klasy InfixApp
////////////////////////////////////////////////////////////////
